/** @file   windingwire.cpp
 * @brief   Implementation of WindingWire - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "WindingWire.h"

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
WindingWire::WindingWire( const Vec2D& rBeg, const Vec2D& rEnd,
                                int nodes, int windingFactor ) :
  Wire( rBeg, rEnd, nodes ),
  m_windingFactor( windingFactor ),
  m_colorScale( Color(230,240,250), Color(170,200,220), Color(90,150,190) )
{
  this->update();
}



/** Destructor
 */
WindingWire::~WindingWire()
{
}




///
/// Public methods
/// ==============

/** Updates this wire
 */
void WindingWire::update()
{
  // Define new color.
  int wh = m_windingFactor >> 2;

  Wire::m_color = m_colorScale.getColorAt( rand() % 100, 0, 100 );
  for ( int i=0; i < Wire::m_nodes.size(); i++ ) {
    Wire::m_nodes.at(i)->offset.set( rand() % m_windingFactor - wh,
                                     rand() % m_windingFactor - wh );
  }
}



/** Sets the gradient
 */
void WindingWire::setColorScale( const Gradient& rG )
{
  m_colorScale = rG;
}



/** Sets the winding factor.
 */
void WindingWire::setWindingFactor( int f )
{
  m_windingFactor = f;
}




///
/// Getter methods
/// ==============

/** Returns the winding factor.
 */
int WindingWire::getWindingFactor() const
{
  return m_windingFactor;
}




///
/// Private or Protected methods
/// ============================

} // end of namespace
